<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use DB;

class AllPaymentsComponent extends Component
{
    use WithPagination;

    public $startDate;
    public $endDate;

    public function render()
    {
        $payments = DB::table('payments')
            ->leftJoin('loans', 'payments.loan_id', '=', 'loans.id')
            ->select(
                'payments.*',
                'loans.applicant_name as user_name',
                'loans.loan_required_amount as loan_amount'
            )
            ->when($this->startDate && $this->endDate, function($query) {
                $query->whereBetween('payments.payment_date', [$this->startDate, $this->endDate]);
            })
            ->orderBy('payments.created_at', 'desc')
            ->paginate(10);

        return view('livewire.all-payments-component', [
            'payments' => $payments
        ]);
    }
}
